package ru.yandex.search.district.search;

import java.util.List;

import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class DistrictSearchRequestsContextProvider
    implements RequestsProvider, DistrictSearchContextProvider
{
    private final BasicDistrictSearchContext context;
    private final List<String> requests;

    public DistrictSearchRequestsContextProvider(
        final BasicDistrictSearchContext context,
        final List<String> requests)
    {
        this.context = context;
        this.requests = requests;
    }

    @Override
    public BasicDistrictSearchContext searchContext() {
        return context;
    }

    @Override
    public List<String> requests() {
        return requests;
    }
}
