package ru.yandex.search.district.search;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DistrictSearchResult {
    private long totalResults;
    private final Map<String, DistrictResultItem> items;

    public DistrictSearchResult() {
        totalResults = 0;

        this.items = new LinkedHashMap<>();
    }

    public DistrictSearchResult(
        final long totalResults)
    {
        this.items = new LinkedHashMap<>();
        this.totalResults = totalResults;
    }

    public void addTotal(final long total) {
        this.totalResults += total;
    }

    public boolean addAll(
        final long total,
        final Collection<? extends DistrictResultItem> c)
    {
        this.totalResults += total;
        int added = 0;
        for (DistrictResultItem item: c) {
            if (!add(item)) {
                totalResults -= 1;
            } else {
                added += 1;
            }
        }

        return added > 0;
    }

    public boolean add(final DistrictResultItem item) {
        DistrictResultItem current =
            this.items.putIfAbsent(item.itemId(), item);
        boolean status = true;
        if (current != null) {
            if (item.rank() > current.rank()) {
                this.items.put(item.itemId(), item);
                status = true;
            } else {
                status = false;
            }
        }

        return status;
    }

    public Collection<DistrictResultItem> items() {
        return items.values();
    }

    public long totalResults() {
        return totalResults;
    }
}
