package ru.yandex.search.district.search;

import java.util.Comparator;

enum RankComparator implements Comparator<DistrictResultItem> {
    INSTANCE;

    @Override
    public int compare(
        final DistrictResultItem o1,
        final DistrictResultItem o2)
    {
        int fuzzyCmp = Long.compare(o2.fuzzyHitRank(), o1.fuzzyHitRank());
        if (fuzzyCmp == 0) {
            return Double.compare(o2.rank(), o1.rank());
        }

        return fuzzyCmp;
    }
}
