package ru.yandex.search.district.suggest;

import java.util.List;

import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class DistrictSuggestContextRequestsProvider
    implements RequestsProvider, DistrictSuggestContextProvider
{
    private final BasicDistrictSuggestContext context;
    private final List<String> requests;

    public DistrictSuggestContextRequestsProvider(
        final BasicDistrictSuggestContext context,
        final List<String> requests)
    {
        this.context = context;
        this.requests = requests;
    }

    @Override
    public BasicDistrictSuggestContext suggestContext() {
        return context;
    }

    @Override
    public List<String> requests() {
        return requests;
    }
}
