package ru.yandex.search.district.suggest;

import java.util.Arrays;
import java.util.List;

import ru.yandex.collection.IntInterval;

public class DistrictSuggestItem {
    private final String request;
    private final IntInterval[] hlIntervals;
    private final int count;

    public DistrictSuggestItem(
        final String request,
        final List<IntInterval> hlIntervals,
        final int count)
    {
        this.request = request;
        this.hlIntervals = new IntInterval[hlIntervals.size()];
        hlIntervals.toArray(this.hlIntervals);
        this.count = count;
    }

    public String request() {
        return request;
    }

    public int count() {
        return count;
    }

    protected IntInterval[] highlight() {
        return hlIntervals;
    }

    @Override
    public String toString() {
        return "DistrictSuggestItem{request='"
            + request + "\', highlight=" + Arrays.toString(hlIntervals)
            + ", count=" + count + '}';
    }
}
