package ru.yandex.search.district.wizard;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

public class DistrictWizardPrinter
    extends AbstractProxySessionCallback<List<JsonObject>>
{
    private final DistrictWizardSearchContext context;

    public DistrictWizardPrinter(
        final ProxySession session,
        final DistrictWizardSearchContext context)
    {
        super(session);
        this.context = context;
    }

    @Override
    public void completed(final List<JsonObject> results) {
        session.connection().setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            Long.toString(results.size()));

        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("total");
            writer.value(results.size());
            writer.key("results");
            writer.value(results);
            writer.endObject();
        } catch (IOException ioe) {
            failed(ioe);
            return;
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(context.session().acceptedCharset())));

        context.proxy().wizardResponse(results.size());
    }
}
