package ru.yandex.search.district.wizard;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.search.district.DistrictSearchProxy;
import ru.yandex.search.rules.pure.SearchRule;

public class DistrictWizardSearchHandler implements ProxyRequestHandler {
    private final SearchRule<DistrictWizardSearchContext,
        List<JsonObject>> rule;

    private final DistrictSearchProxy proxy;

    public DistrictWizardSearchHandler(
        final DistrictSearchProxy proxy)
    {
        this.proxy = proxy;

        this.rule = new DistrictWizardSearchRule<>();
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        DistrictWizardSearchContext context =
            new DistrictWizardSearchContext(proxy, session);
        rule.execute(context, new DistrictWizardPrinter(session, context));
    }
}
