package ru.yandex.search.district.wizard;

import java.util.List;
import java.util.Locale;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.district.AbstractDistrictSearchRule;
import ru.yandex.search.district.DistrictConstants;
import ru.yandex.search.district.DistrictEntityType;
import ru.yandex.search.district.DistrictFields;
import ru.yandex.search.district.search.SearchScope;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class DistrictWizardSearchRule
    <T extends RequestProvider & DistrictWizardContextProvider>
    extends AbstractDistrictSearchRule
    implements SearchRule<T, List<JsonObject>>
{
    private static final Long FAIL_OVER_INT = 60L;

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super List<JsonObject>> callback)
        throws HttpException
    {
        DistrictWizardSearchContext context = input.searchContext();

        QueryConstructor query =
            new QueryConstructor(
                "/search-wizard?IO_PRIO=0");

        query.append("service", context.user().service());
        StringBuilder text = new StringBuilder();
        if (context.entityType() == DistrictEntityType.ALL) {
            addFilter(
                text,
                DistrictFields.INDEX_TYPE,
                SearchScope.DISTRICTS,
                DistrictConstants.CITY_INDEX_TYPE);
        } else {
            text.append("entity_type_p:");
            text.append(context.entityType().entityType());
        }

        if (context.onlyNice()) {
            text.append("AND looks_nice_p:true");
        }

        SearchRequestText fuzzyText = SearchRequestText.parseSuggest(
            input.request(),
            context.session().params().getLocale("locale", Locale.ROOT));

        if (fuzzyText.hasWords()) {
            text.append(AND);
            text.append('(');
            String fuzzyField = DistrictFields.TEXT.prefixedField();
            fuzzyText.fieldsQuery(text, fuzzyField);
            fuzzyText.negationsQuery(text, fuzzyField);
            text.append(')');
        }

        query.append("text", text.toString());
        query.append("prefix", context.cityId());
        query.append("get", context.get());
        query.append("length", context.length());
        query.append("collector", "passthru(" + context.length() + ')');

        String uri = query.toString();
        context.searchContext().logger().info(uri);
        context.proxy().sequentialRequest(
            context.session(),
            context,
            new BasicAsyncRequestProducerGenerator(uri),
            FAIL_OVER_INT,
            false,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.contextGenerator(),
            new WizardSearchCallback(callback));
    }

    private static final class WizardSearchCallback
        extends AbstractFilterFutureCallback<JsonObject, List<JsonObject>>
    {
        private WizardSearchCallback(
            final FutureCallback<? super List<JsonObject>> callback)
        {
            super(callback);
        }

        @Override
        public void completed(final JsonObject response) {
            try {
                callback.completed(response.asMap().get("hitsArray").asList());
            } catch (JsonException je) {
                failed(je);
            }
        }
    }
}
