package ru.yandex.erratum;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractErratumConfigBuilder
    <T extends AbstractErratumConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements ErratumConfig
{
    private String service;
    private boolean enablePorno;
    private boolean enableTranslit;
    private boolean enableKeyboard;
    private boolean ignoreNicknames;

    protected AbstractErratumConfigBuilder(final ErratumConfig config) {
        super(config);
        service(config.service());
        enablePorno(config.enablePorno());
        enableTranslit(config.enableTranslit());
        enableKeyboard(config.enableKeyboard());
        ignoreNicknames(config.ignoreNicknames());
    }

    protected AbstractErratumConfigBuilder(
        final IniConfig config,
        final ErratumConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        service = config.get(
            "service",
            defaults.service(),
            NonEmptyValidator.INSTANCE);
        enablePorno =
            config.getBoolean("enable-porno", defaults.enablePorno());
        enableTranslit =
            config.getBoolean("enable-translit", defaults.enableTranslit());
        enableKeyboard =
            config.getBoolean("enable-keyboard", defaults.enableKeyboard());
        ignoreNicknames =
            config.getBoolean("ignore-nicknames", defaults.ignoreNicknames());
    }

    @Override
    public String service() {
        return service;
    }

    public T service(final String service) {
        this.service = service;
        return self();
    }

    @Override
    public boolean enablePorno() {
        return enablePorno;
    }

    public T enablePorno(final boolean enablePorno) {
        this.enablePorno = enablePorno;
        return self();
    }

    @Override
    public boolean enableTranslit() {
        return enableTranslit;
    }

    public T enableTranslit(final boolean enableTranslit) {
        this.enableTranslit = enableTranslit;
        return self();
    }

    @Override
    public boolean enableKeyboard() {
        return enableKeyboard;
    }

    public T enableKeyboard(final boolean enableKeyboard) {
        this.enableKeyboard = enableKeyboard;
        return self();
    }

    @Override
    public boolean ignoreNicknames() {
        return ignoreNicknames;
    }

    public T ignoreNicknames(
        final boolean ignoreNicknames)
    {
        this.ignoreNicknames = ignoreNicknames;
        return self();
    }
}
