package ru.yandex.erratum;

public abstract class AbstractErratumResult implements ErratumResult {
    private static final int UNRELIABLE_FLAG = 0x4;
    private static final int PORNO_FLAG = 0x8;
    private static final int CONTEXT_FLAG = 0x20;
    private static final int SPLIT_FLAG = 0x40;
    private static final int JOIN_FLAG = 0x80;
    private static final int REJECTED_FLAG = 0x100;
    private static final int VOLAPYUK_FLAG = 0x200;
    private static final int KEYBOARD_FLAG = 0x400;

    private final int flags;

    protected AbstractErratumResult(final int flags) {
        this.flags = flags;
    }

    @Override
    public boolean unreliable() {
        return (flags & UNRELIABLE_FLAG) != 0;
    }

    @Override
    public boolean porno() {
        return (flags & PORNO_FLAG) != 0;
    }

    @Override
    public boolean context() {
        return (flags & CONTEXT_FLAG) != 0;
    }

    @Override
    public boolean split() {
        return (flags & SPLIT_FLAG) != 0;
    }

    @Override
    public boolean join() {
        return (flags & JOIN_FLAG) != 0;
    }

    @Override
    public boolean rejected() {
        return (flags & REJECTED_FLAG) != 0;
    }

    @Override
    public boolean volapyuk() {
        return (flags & VOLAPYUK_FLAG) != 0;
    }

    @Override
    public boolean keyboard() {
        return (flags & KEYBOARD_FLAG) != 0;
    }
}

