package ru.yandex.erratum;

import java.util.ArrayList;
import java.util.List;

public class BasicErratumResult extends AbstractErratumResult {
    private final List<String> parts = new ArrayList<>();
    private final List<String> srcParts = new ArrayList<>();
    private final int code;
    private final int safety;
    private final String lang;
    private final String rule;
    private final String text;
    private final String srcText;

    public BasicErratumResult(final ErratumResultBuilder builder) {
        super(builder.flags());
        code = builder.code();
        safety = builder.safety();
        lang = builder.lang();
        rule = builder.rule();
        text = join(builder.text(), parts);
        srcText = join(builder.srcText(), srcParts);
    }

    private static String join(final String text, final List<String> parts) {
        int pos = 0;
        while (pos < text.length()) {
            int idx = text.indexOf("\u00ad(", pos);
            if (idx == -1) {
                parts.add(text.substring(pos, text.length()));
                pos = text.length() + 1;
            } else {
                parts.add(text.substring(pos, idx));
                pos = idx + 2;
                idx = text.indexOf(")\u00ad", pos);
                if (idx == -1) {
                    parts.add(text.substring(pos, text.length()));
                    pos = text.length() + 1;
                } else {
                    parts.add(text.substring(pos, idx));
                    pos = idx + 2;
                }
            }
        }
        if (pos == text.length()) {
            parts.add("");
        }
        StringBuilder sb = new StringBuilder();
        for (String part: parts) {
            sb.append(part);
        }
        return sb.toString();
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public int safety() {
        return safety;
    }

    @Override
    public String lang() {
        return lang;
    }

    @Override
    public String rule() {
        return rule;
    }

    @Override
    public String text() {
        return text;
    }

    @Override
    public List<String> parts() {
        return parts;
    }

    @Override
    public String srcText() {
        return srcText;
    }

    @Override
    public List<String> srcParts() {
        return srcParts;
    }

    @Override
    public String toString() {
        return "Erratum(" + code + ',' + ' ' + rule + ',' + ' ' + srcParts
            + " -> " + parts + ')';
    }
}

