package ru.yandex.erratum;

import java.util.Collections;
import java.util.List;

public class EmptyErratumResult extends AbstractErratumResult {
    public static final EmptyErratumResult INSTANCE = new EmptyErratumResult();

    private final int code;

    protected EmptyErratumResult() {
        this(CODE_NOT_CORRECTED, 0);
    }

    public EmptyErratumResult(final int code, final int flags) {
        super(flags);
        this.code = code;
    }

    @Override
    public int code() {
        return code;
    }

    @Override
    public int safety() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lang() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String rule() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String text() {
        return null;
    }

    @Override
    public List<String> parts() {
        return Collections.emptyList();
    }

    @Override
    public String srcText() {
        return null;
    }

    @Override
    public List<String> srcParts() {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "Erratum(" + code + ')';
    }
}

