package ru.yandex.erratum;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ErratumConfigBuilder
    extends AbstractErratumConfigBuilder<ErratumConfigBuilder>
{
    public ErratumConfigBuilder() {
        super(ErratumConfigDefaults.INSTANCE);
    }

    public ErratumConfigBuilder(final ErratumConfig config) {
        super(config);
    }

    public ErratumConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, ErratumConfigDefaults.INSTANCE);
    }

    public ErratumConfigBuilder(
        final IniConfig config,
        final ErratumConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ErratumConfigBuilder self() {
        return this;
    }

    public ImmutableErratumConfig build() throws ConfigException {
        return new ImmutableErratumConfig(this);
    }
}

