package ru.yandex.erratum;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;
import ru.yandex.json.parser.StringCollectorsFactory;

public class ErratumConsumer extends JsonAsyncConsumer<ErratumResult> {
    private final ErratumResultBuilder builder;

    public ErratumConsumer(final HttpEntity entity) throws HttpException {
        this(entity, new ErratumResultBuilder());
    }

    private ErratumConsumer(
        final HttpEntity entity,
        final ErratumResultBuilder builder)
        throws HttpException
    {
        super(
            entity,
            builder,
            StringCollectorsFactory.INSTANCE);
        this.builder = builder;
    }

    @Override
    protected ErratumResult doBuildResult(final HttpContext context) {
        return builder.build();
    }
}

