package ru.yandex.erratum;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class ErratumConsumerFactory
    implements HttpAsyncResponseConsumerFactory<ErratumResult>
{
    public static final ErratumConsumerFactory INSTANCE =
        new ErratumConsumerFactory();
    public static final HttpAsyncResponseConsumerFactory<ErratumResult> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    protected ErratumConsumerFactory() {
    }

    @Override
    public ErratumConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ErratumConsumer(response.getEntity());
    }
}

