package ru.yandex.erratum;

import java.util.List;

import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class ErratumResultBuilder implements PrimitiveHandler {
    private int code = ErratumResult.CODE_NOT_CORRECTED;
    private int flags = 0;
    private int safety = 0;
    private String lang = null;
    private String rule = null;
    private String text = null;
    private String srcText = "";

    public int code() {
        return code;
    }

    public int flags() {
        return flags;
    }

    public int safety() {
        return safety;
    }

    public String lang() {
        return lang;
    }

    public String rule() {
        return rule;
    }

    public String text() {
        return text;
    }

    public String srcText() {
        return srcText;
    }

    public ErratumResult build() {
        if (text != null && text.isEmpty()) {
            text = null;
        }
        if (text == null) {
            if (code == ErratumResult.CODE_CORRECTED) {
                code = ErratumResult.CODE_NOT_CORRECTED;
            }
            return new EmptyErratumResult(code, flags);
        } else {
            code = ErratumResult.CODE_CORRECTED;
            return new BasicErratumResult(this);
        }
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value) {
        if (path.size() == 1) {
            String field = path.get(0).name();
            if (field != null) {
                if (value instanceof String) {
                    String str = (String) value;
                    switch (field) {
                        case "lang":
                            lang = str;
                            break;
                        case "rule":
                            rule = str;
                            break;
                        case "text":
                            text = str;
                            break;
                        case "srcText":
                            srcText = str;
                            break;
                        default:
                            break;
                    }
                } else if (value instanceof Number) {
                    int v = ((Number) value).intValue();
                    switch (field) {
                        case "code":
                            code = v;
                            break;
                        case "flags":
                            flags = v;
                            break;
                        case "r":
                            safety = v;
                            break;
                        default:
                            break;
                    }
                }
            }
        }
    }
}

