package ru.yandex.erratum;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableErratumConfig
    extends ImmutableHttpHostConfig
    implements ErratumConfig
{
    private final String service;
    private final boolean enablePorno;
    private final boolean enableTranslit;
    private final boolean enableKeyboard;
    private final boolean ignoreNicknames;

    public ImmutableErratumConfig(final ErratumConfig config)
        throws ConfigException
    {
        super(config);
        service = config.service();
        enablePorno = config.enablePorno();
        enableTranslit = config.enableTranslit();
        enableKeyboard = config.enableKeyboard();
        ignoreNicknames = config.ignoreNicknames();

        if (service == null) {
            throw new ConfigException("service name is not set");
        }
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public boolean enablePorno() {
        return enablePorno;
    }

    @Override
    public boolean enableTranslit() {
        return enableTranslit;
    }

    @Override
    public boolean enableKeyboard() {
        return enableKeyboard;
    }

    @Override
    public boolean ignoreNicknames() {
        return ignoreNicknames;
    }
}

