package ru.yandex.jzabkv;

import com.github.zk1931.jzab.ZabException;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.ServiceUnavailableException;

import ru.yandex.jzabkv.command.ClearCommand;

public class ClearHandler implements ProxyRequestHandler {
    private final Database db;

    public ClearHandler(final JZabKV server, final Database db) {
        this.db = db;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        try {
            db.add(new ClearCommand(), new ClearCallback(session));
        } catch (IOException | ZabException e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static final class ClearCallback
        extends AbstractProxySessionCallback<Void>
    {
        ClearCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Void v) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
