package ru.yandex.jzabkv;

import com.github.zk1931.jzab.ZabException;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.ServiceUnavailableException;

import ru.yandex.jzabkv.command.DeleteCommand;
import ru.yandex.jzabkv.key.UTF8StringKey;

public class DeleteHandler implements ProxyRequestHandler {
    private final Database db;

    public DeleteHandler(final JZabKV server, final Database db) {
        this.db = db;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        final UTF8StringKey key =
            new UTF8StringKey(session.params().getString("key"));
        try {
            db.add(new DeleteCommand(key), new DeleteCallback(session));
        } catch (IOException | ZabException e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static final class DeleteCallback
        extends AbstractProxySessionCallback<Void>
    {
        DeleteCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final Void v) {
            session.response(HttpStatus.SC_OK);
        }
    }
}
