package ru.yandex.jzabkv;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

public class DumpHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final Database db;

    public DumpHandler(final JZabKV server, final Database db) {
        this.db = db;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        db.dump();
        exchange.getResponse().setEntity(
            new NStringEntity(
                "Ok",
                ContentType.TEXT_PLAIN));
        exchange.submitResponse();
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }
}
