package ru.yandex.jzabkv;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.nio.entity.NStringEntity;

//import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.ServiceUnavailableException;

import ru.yandex.jzabkv.key.UTF8StringKey;
import ru.yandex.jzabkv.node.Node;

public class GetHandler implements ProxyRequestHandler {
    private final Database db;

    public GetHandler(final JZabKV server, final Database db) {
        this.db = db;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        final UTF8StringKey key =
            new UTF8StringKey(session.params().getString("key"));
        final Node node = db.get(key);
        if (node == null) {
            session.response(HttpStatus.SC_NOT_FOUND);
        } else {
            try {
                session.response(
                    HttpStatus.SC_OK,
                    new NByteArrayEntity(node.bytes()));
            } catch (Exception e) {
                throw new ServiceUnavailableException(e);
            }
        }
    }
}
