package ru.yandex.jzabkv;

import java.io.File;
import java.util.Collections;
import java.util.Set;

import ru.yandex.http.util.server.ImmutableHttpProxyConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableJZabKVConfig
    extends ImmutableHttpProxyConfig
    implements JZabKVConfig
{
    private final File logDir;
    private final File dataDir;
    private final String serverId;
    private final Set<String> peers;
    private final long peerTimeout;
    private final long syncTimeout;
    private final int bossNioThreads;
    private final int workerNioThreads;
    private final long deliverSnapshotInterval;
    private final long modifySnapshotInterval;
    private final long sizeSnapshotInterval;
    private final long maxDatabaseSize;
    private final long defaultTTL;

    public ImmutableJZabKVConfig(
        final JZabKVConfig config)
        throws ConfigException
    {
        super(config);
        logDir = config.logDir();
        dataDir = config.dataDir();
        serverId = config.serverId();
        peers = Collections.unmodifiableSet(config.peers());
        if (peers.isEmpty()) {
            throw new ConfigException("Empty \"peers\" parameter");
        }
        peerTimeout = config.peerTimeout();
        syncTimeout = config.syncTimeout();
        bossNioThreads = config.bossNioThreads();
        workerNioThreads = config.workerNioThreads();
        deliverSnapshotInterval = config.deliverSnapshotInterval();
        modifySnapshotInterval = config.modifySnapshotInterval();
        sizeSnapshotInterval = config.sizeSnapshotInterval();
        maxDatabaseSize = config.maxDatabaseSize();
        defaultTTL = config.defaultTTL();
    }

    @Override
    public File logDir() {
        return logDir;
    }

    @Override
    public File dataDir() {
        return dataDir;
    }

    @Override
    public String serverId() {
        return serverId;
    }

    @Override
    public Set<String> peers() {
        return peers;
    }

    @Override
    public long peerTimeout() {
        return peerTimeout;
    }

    @Override
    public long syncTimeout() {
        return syncTimeout;
    }

    @Override
    public int bossNioThreads() {
        return bossNioThreads;
    }

    @Override
    public int workerNioThreads() {
        return workerNioThreads;
    }

    @Override
    public long deliverSnapshotInterval() {
        return deliverSnapshotInterval;
    }

    @Override
    public long modifySnapshotInterval() {
        return modifySnapshotInterval;
    }

    @Override
    public long sizeSnapshotInterval() {
        return sizeSnapshotInterval;
    }

    @Override
    public long maxDatabaseSize() {
        return maxDatabaseSize;
    }

    @Override
    public long defaultTTL() {
        return defaultTTL;
    }
}
