package ru.yandex.jzabkv;

import java.io.IOException;
import java.util.logging.Level;

import com.github.zk1931.jzab.ZabException;
import org.apache.http.HttpRequest;

import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.TimeFrameQueue;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.server.async.DelegatedHttpAsyncRequestHandler;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.stater.CountAggregatorFactory;
import ru.yandex.stater.DuplexStaterFactory;
import ru.yandex.stater.NamedStatsAggregatorFactory;
import ru.yandex.stater.PassiveStaterAdapter;
import ru.yandex.stater.Stater;
import ru.yandex.stater.StatsConsumer;

public class JZabKV extends HttpProxy<ImmutableJZabKVConfig> {
    private final Database db;
    private final TimeFrameQueue<Long> nodesEviction;

    public JZabKV(final ImmutableJZabKVConfig config)
        throws IOException
    {
        super(config);
        db = new Database(this);

        register(
            new Pattern<>("/put", false),
            new PutHandler(this, db));
        register(
            new Pattern<>("/get", false),
            new GetHandler(this, db),
            RequestHandlerMapper.GET);
        register(
            new Pattern<>("/delete", false),
            new DeleteHandler(this, db),
            RequestHandlerMapper.GET);
        register(
            new Pattern<>("/clear", false),
            new ClearHandler(this, db),
            RequestHandlerMapper.GET);
        register(
            new Pattern<>("/size", false),
            new DelegatedHttpAsyncRequestHandler<HttpRequest>(
                new SizeHandler(this, db),
                this),
            RequestHandlerMapper.GET);
        register(
            new Pattern<>("/dump", false),
            new DelegatedHttpAsyncRequestHandler<HttpRequest>(
                new DumpHandler(this, db),
                this),
            RequestHandlerMapper.GET);
        register(
            new Pattern<>("/snapshot", false),
            new SnapshotHandler(this, db),
            RequestHandlerMapper.GET);
        registerStater(new Huyater());
        nodesEviction = new TimeFrameQueue<>(config.metricsTimeFrame());
        registerStater(
            new PassiveStaterAdapter<>(
                nodesEviction,
                new DuplexStaterFactory<>(
                    new NamedStatsAggregatorFactory<>(
                        "nodes_eviction_ammm",
                        CountAggregatorFactory.INSTANCE),
                    new NamedStatsAggregatorFactory<>(
                        "nodex_eviction_axxx",
                        CountAggregatorFactory.INSTANCE))));
    }

    public void nodesEvicted(final int count) {
        nodesEviction.accept((long) count);
    }

    @Override
    public void close() throws IOException {
        super.close();
        try {
            logger().severe("Snapshoting on close");
            db.snapshot(true);
        } catch (Throwable e) {
            logger().log(Level.SEVERE, "Snapshoting on close failed", e);
        }
        db.close();
    }

    private class Huyater implements Stater {
        @Override
        public <E extends Exception> void stats(
            final StatsConsumer<? extends E> statsConsumer)
            throws E
        {
            statsConsumer.stat(
                "zab_is_leader_axxx",
                db.isLeader());
            statsConsumer.stat(
                "zab_is_broadcasting_ammm",
                db.broadcasting());
            statsConsumer.stat(
                "kvdb_node_count_axxx",
                db.size());
            statsConsumer.stat(
                "kvdb_size_in_bytes_axxx",
                db.weight());
            statsConsumer.stat(
                "kvdb_max_size_in_bytes_axxx",
                db.maxWeight());
        }
    }
}

