package ru.yandex.jzabkv;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class JZabKVConfigBuilder
    extends AbstractJZabKVConfigBuilder<
        JZabKVConfigBuilder>
{
    public JZabKVConfigBuilder()
        throws ConfigException
    {
        super(JZabKVConfigDefaults.INSTANCE);
    }

    public JZabKVConfigBuilder(
        final JZabKVConfig config)
        throws ConfigException
    {
        super(config);
    }

    public JZabKVConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, JZabKVConfigDefaults.INSTANCE);
    }

    public JZabKVConfigBuilder(
        final IniConfig config,
        final JZabKVConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public JZabKVConfigBuilder self() {
        return this;
    }

    public ImmutableJZabKVConfig build()
        throws ConfigException
    {
        return new ImmutableJZabKVConfig(this);
    }
}
