package ru.yandex.jzabkv;

import java.io.File;
import java.util.Collections;
import java.util.Set;

import ru.yandex.http.util.server.HttpProxyConfigDefaults;

public class JZabKVConfigDefaults
    extends HttpProxyConfigDefaults
    implements JZabKVConfig
{
    public static final JZabKVConfigDefaults INSTANCE =
        new JZabKVConfigDefaults();

    private static final int DEFAULT_PEER_TIMEOUT = 30000;
    private static final int DEFAULT_SYNC_TIMEOUT = 120000;
    private static final int DEFAULT_BOSS_NIO_THREADS =
        Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_WORKER_NIO_THREADS =
        DEFAULT_BOSS_NIO_THREADS;
    private static final long DELIVER_SNAPSHOT_INTERVAL = 500000;
    private static final long MODIFY_SNAPSHOT_INTERVAL = 2000000;
    private static final long SIZE_SNAPSHOT_INTERVAL = 2L * 1024 * 1024 * 1024;
    private static final long MAX_DATABASE_SIZE = 2L * 1024 * 1024 * 1024;
    private static final long DEFAULT_TTL = 3600 * 1000;

    protected JZabKVConfigDefaults() {
    }

    @Override
    public File logDir() {
        return new File("./logs");
    }

    @Override
    public File dataDir() {
        return new File("./data");
    }

    @Override
    public String serverId() {
        return null;
    }

    @Override
    public Set<String> peers() {
        return Collections.emptySet();
    }

    @Override
    public long peerTimeout() {
        return DEFAULT_PEER_TIMEOUT;
    }

    @Override
    public long syncTimeout() {
        return DEFAULT_SYNC_TIMEOUT;
    }

    @Override
    public int bossNioThreads() {
        return DEFAULT_BOSS_NIO_THREADS;
    }

    @Override
    public int workerNioThreads() {
        return DEFAULT_WORKER_NIO_THREADS;
    }

    @Override
    public long deliverSnapshotInterval() {
        return DELIVER_SNAPSHOT_INTERVAL;
    }

    @Override
    public long modifySnapshotInterval() {
        return MODIFY_SNAPSHOT_INTERVAL;
    }

    @Override
    public long sizeSnapshotInterval() {
        return SIZE_SNAPSHOT_INTERVAL;
    }

    @Override
    public long maxDatabaseSize() {
        return MAX_DATABASE_SIZE;
    }

    @Override
    public long defaultTTL() {
        return DEFAULT_TTL;
    }
}
