package ru.yandex.jzabkv;

import java.io.IOException;

public class ReusableByteArrayDataInput extends ReusableDataInput {
    private byte[] bytes;
    private int pos;

    public ReusableByteArrayDataInput(final byte[] bytes) {
        this.bytes = bytes;
        pos = 0;
    }

    @Override
    public void reset(final byte[] bytes) {
        this.bytes = bytes;
        pos = 0;
    }

    @Override
    public void clear() {
        this.bytes = null;
        pos = 0;
    }

    @Override
    public byte get() throws IOException {
        return bytes[pos++];
    }

    @Override
    public void get(final byte[] buf) {
        System.arraycopy(bytes, pos, buf, 0, buf.length);
        pos += buf.length;
    }

    @Override
    public void get(final byte[] buf, final int off, final int len) {
        System.arraycopy(bytes, pos, buf, off, len);
        pos += len;
    }

    //CSOFF: MagicNumber
    public int getInt() throws IOException {
        return ((get() & 0xFF) << 24) | ((get() & 0xFF) << 16)
            | ((get() & 0xFF) << 8) | (get() & 0xFF);
    }
    //CSON: MagicNumber

    //CSOFF: MagicNumber
    public long getLong() throws IOException {
        return (((long) getInt()) << 32) | (getInt() & 0xFFFFFFFFL);
    }
    //CSON: MagicNumber

    public float getFloat() throws IOException {
        return Float.intBitsToFloat(getInt());
    }
}
