package ru.yandex.jzabkv;

import java.io.IOException;

import java.nio.ByteBuffer;

public class ReusableByteBufferDataInput extends ReusableDataInput {
    private ByteBuffer bb;

    public ReusableByteBufferDataInput(final ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public void reset(final ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public void clear() {
        this.bb = null;
    }

    @Override
    public byte get() throws IOException {
        return bb.get();
    }

    @Override
    public void get(final byte[] buf) {
        bb.get(buf);
    }

    @Override
    public void get(final byte[] buf, final int off, final int len) {
        bb.get(buf, off, len);
    }

    @Override
    public int getInt() {
        return bb.getInt();
    }

    @Override
    public long getLong() {
        return bb.getLong();
    }

    @Override
    public float getFloat() {
        return bb.getFloat();
    }
}
