package ru.yandex.jzabkv;

import java.io.IOException;
import java.io.InputStream;

import java.nio.ByteBuffer;

public abstract class ReusableDataInput {
    private static final ThreadLocal<ReusableByteArrayDataInput>
        BYTE_ARRAY_TLH =
            new ThreadLocal<>();
    private static final ThreadLocal<ReusableByteBufferDataInput>
        BYTE_BUFFER_TLH =
            new ThreadLocal<>();
    private static final ThreadLocal<ReusableInputStreamDataInput>
        INPUT_STREAM_TLH =
            new ThreadLocal<>();

    public static ReusableDataInput threadLocal(final byte[] bytes) {
        ReusableByteArrayDataInput rdi = BYTE_ARRAY_TLH.get();
        if (rdi == null) {
            rdi = new ReusableByteArrayDataInput(bytes);
            BYTE_ARRAY_TLH.set(rdi);
        } else {
            rdi.reset(bytes);
        }
        return rdi;
    }

    public static ReusableDataInput threadLocal(final ByteBuffer bb) {
        ReusableByteBufferDataInput rdi = BYTE_BUFFER_TLH.get();
        if (rdi == null) {
            rdi = new ReusableByteBufferDataInput(bb);
            BYTE_BUFFER_TLH.set(rdi);
        } else {
            rdi.reset(bb);
        }
        return rdi;
    }

    public static ReusableDataInput threadLocal(final InputStream is) {
        ReusableInputStreamDataInput rdi = INPUT_STREAM_TLH.get();
        if (rdi == null) {
            rdi = new ReusableInputStreamDataInput(is);
            INPUT_STREAM_TLH.set(rdi);
        } else {
            rdi.reset(is);
        }
        return rdi;
    }

    public void reset(final byte[] data) {
        throw new UnsupportedOperationException();
    }

    public void reset(final ByteBuffer bb) {
        throw new UnsupportedOperationException();
    }

    public void reset(final InputStream is) {
        throw new UnsupportedOperationException();
    }

    public abstract void clear();

    public boolean getBoolean() throws IOException {
        byte b = get();
        if (b == 1) {
            return true;
        } else if (b == 0) {
            return false;
        } else {
            throw new IOException("Illegal boolean value: " + b);
        }
    }

    public abstract byte get() throws IOException;

    public abstract void get(final byte[] buf) throws IOException;

    public abstract void get(final byte[] buf, final int off, final int len)
        throws IOException;

    public abstract int getInt() throws IOException;

    public abstract long getLong() throws IOException;

    public abstract float getFloat() throws IOException;
}
