package ru.yandex.jzabkv;

import java.io.IOException;
import java.io.InputStream;

public class ReusableInputStreamDataInput extends ReusableDataInput {
    private static final String EOF = "Read past EOF";

    private InputStream is;

    public ReusableInputStreamDataInput(final InputStream is) {
        this.is = is;
    }

    @Override
    public void reset(final InputStream is) {
        this.is = is;
    }

    @Override
    public void clear() {
        this.is = null;
    }

    @Override
    public byte get() throws IOException {
        int b = is.read();
        if (b == -1) {
            throw new IOException(EOF);
        }
        return (byte) b;
    }

    @Override
    public void get(final byte[] buf) throws IOException {
        int n = is.read(buf);
        if (n == -1) {
            throw new IOException(EOF);
        }
    }

    @Override
    public void get(final byte[] buf, final int off, final int len)
        throws IOException
    {
        int n = is.read(buf, off, len);
        if (n == -1) {
            throw new IOException(EOF);
        }
    }

    @Override
    //CSOFF: MagicNumber
    public int getInt() throws IOException {
        return ((get() & 0xFF) << 24) | ((get() & 0xFF) << 16)
            | ((get() & 0xFF) << 8) | (get() & 0xFF);
    }
    //CSON: MagicNumber

    @Override
    //CSOFF: MagicNumber
    public long getLong() throws IOException {
        return (((long) getInt()) << 32) | (getInt() & 0xFFFFFFFFL);
    }
    //CSON: MagicNumber

    public float getFloat() throws IOException {
        return Float.intBitsToFloat(getInt());
    }
}
