package ru.yandex.jzabkv;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.ServiceUnavailableException;

public class SnapshotHandler implements ProxyRequestHandler {
//    private final JZabKV server;
    private final Database db;

    public SnapshotHandler(final JZabKV server, final Database db) {
//        this.server = server;
        this.db = db;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        try {
            db.snapshot(new SnapshotCallback(session));
        } catch (Exception e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static final class SnapshotCallback
        extends AbstractProxySessionCallback<String>
    {
        SnapshotCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final String v) {
            try {
                session.response(
                    HttpStatus.SC_OK,
                    new NStringEntity(v));
            } catch (Exception e) {
                failed(e);
            }
        }
    }
}
