package ru.yandex.jzabkv.command;

import java.io.IOException;
import java.util.Collection;

import ru.yandex.jzabkv.Database;
import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;
import ru.yandex.jzabkv.Serializer;
import ru.yandex.jzabkv.key.Key;
import ru.yandex.jzabkv.key.UTF8StringKey;
import ru.yandex.jzabkv.node.Node;
import ru.yandex.jzabkv.node.StringNode;

public final class CleanupCommand extends AbstractCommand {
    private static final Node FAKE_NODE =
        new StringNode(new UTF8StringKey("qwe"), "qwe", 0);

    public CleanupCommand() {
    }

    public CleanupCommand(final ReusableDataInput rdi)
        throws IOException
    {
    }

    @Override
    public void execute(final Database db) {
        //noop
    }

    @Override
    public Command preprocess(final Database db) {
        Collection<Key> toEvict = db.tryPut(FAKE_NODE);
        if (toEvict.isEmpty()) {
            return this;
        } else {
            MultiCommand mc = new MultiCommand(toEvict.size() + 1);
            for (Key k: toEvict) {
                mc.add(new DeleteCommand(k));
            }
            return mc;
        }
    }

    @Override
    public void serialize(final ReusableDataOutputStream stream)
        throws IOException
    {
    }

    @Override
    public CommandType type() {
        return CommandType.CLEANUP;
    }
}
