package ru.yandex.jzabkv.command;

import java.io.IOException;

import ru.yandex.jzabkv.ReusableDataInput;

public enum CommandType {
    PUT {
        @Override
        public Command create(final ReusableDataInput rdi)
            throws IOException
        {
            return new PutCommand(rdi);
        }
    },
    DELETE {
        @Override
        public Command create(final ReusableDataInput rdi)
            throws IOException
        {
            return new DeleteCommand(rdi);
        }
    },
    MULTI {
        @Override
        public Command create(final ReusableDataInput rdi)
            throws IOException
        {
            return new MultiCommand(rdi);
        }
    },
    CLEAR {
        @Override
        public Command create(final ReusableDataInput rdi)
            throws IOException
        {
            return new ClearCommand(rdi);
        }
    },
    CLEANUP {
        @Override
        public Command create(final ReusableDataInput rdi)
            throws IOException
        {
            return new CleanupCommand(rdi);
        }
    };

    public abstract Command create(final ReusableDataInput rdi)
        throws IOException;
}
