package ru.yandex.jzabkv.command;

import java.io.IOException;

import ru.yandex.jzabkv.Database;
import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;
import ru.yandex.jzabkv.Serializer;
import ru.yandex.jzabkv.key.Key;

public final class DeleteCommand extends AbstractCommand {
    private final Key key;

    public DeleteCommand(final Key key) {
        this.key = key;
    }

    public DeleteCommand(final ReusableDataInput rdi)
        throws IOException
    {
        key = Serializer.deserializeKey(rdi);
    }

    @Override
    public void execute(final Database db) {
        db.delete(key);
    }

    @Override
    public Command preprocess(final Database db) {
        return this;
    }

    @Override
    public void serialize(final ReusableDataOutputStream stream)
        throws IOException
    {
        key.write(stream);
    }

    @Override
    public CommandType type() {
        return CommandType.DELETE;
    }
}
