package ru.yandex.jzabkv.command;

import java.io.IOException;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.jzabkv.Database;
import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;
import ru.yandex.jzabkv.Serializer;

public final class MultiCommand extends AbstractCommand {
    private final List<Command> commands;

    public MultiCommand() {
        commands = new ArrayList<>();
    }

    public MultiCommand(final int size) {
        commands = new ArrayList<>(size);
    }

    public MultiCommand(final ReusableDataInput rdi)
        throws IOException
    {
        int size = rdi.getInt();
        commands = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            Command command = Serializer.deserialize(rdi);
            commands.add(command);
        }
    }

    public void add(final Command command) {
        commands.add(command);
    }

    @Override
    public void execute(final Database db) {
        int size = commands.size();
        for (int i = 0; i < size; i++) {
            commands.get(i).execute(db);
        }
    }

    @Override
    public Command preprocess(final Database db) {
        int size = commands.size();
        for (int i = 0; i < size; i++) {
            Command command = commands.get(i).preprocess(db);
            commands.set(i, command);
        }
        return this;
    }

    @Override
    public void serialize(final ReusableDataOutputStream stream)
        throws IOException
    {
        int size = commands.size();
        stream.writeInt(size);
        for (int i = 0; i < size; i++) {
            Serializer.serialize(commands.get(i), stream);
        }
    }

    @Override
    public CommandType type() {
        return CommandType.MULTI;
    }
}
