package ru.yandex.jzabkv.command;

import java.io.IOException;
import java.util.Collection;

import ru.yandex.jzabkv.Database;
import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;
import ru.yandex.jzabkv.Serializer;
import ru.yandex.jzabkv.key.Key;
import ru.yandex.jzabkv.node.Node;

public final class PutCommand extends AbstractCommand {
    private final Node node;

    public PutCommand(final Node node) {
        this.node = node;
    }

    public PutCommand(final ReusableDataInput rdi)
        throws IOException
    {
        Key key = Serializer.deserializeKey(rdi);
        node = Serializer.deserializeNode(key, rdi);
    }

    @Override
    public void execute(final Database db) {
        db.put(node);
    }

    @Override
    public Command preprocess(final Database db) {
//        System.err.println("Preprocessing");
        Collection<Key> toEvict = db.tryPut(node);
        if (toEvict.isEmpty()) {
            return this;
        } else {
            MultiCommand mc = new MultiCommand(toEvict.size() + 1);
            mc.add(this);
            for (Key k: toEvict) {
                mc.add(new DeleteCommand(k));
            }
            return mc;
        }
    }

    @Override
    public void serialize(final ReusableDataOutputStream stream)
        throws IOException
    {
        node.key().write(stream);
        node.write(stream);
    }

    @Override
    public CommandType type() {
        return CommandType.PUT;
    }
}
