package ru.yandex.jzabkv.key;

import java.io.IOException;

import java.nio.charset.StandardCharsets;

import java.util.Arrays;

import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;

public class UTF8StringKey extends AbstractKey {
    private static final int OVERHEAD = 50;
    private final byte[] data;

    public UTF8StringKey(final String key) {
        this.data = key.getBytes(StandardCharsets.UTF_8);
    }

    public UTF8StringKey(final byte[] data) {
        this.data = data;
    }

    public UTF8StringKey(final ReusableDataInput rdi) throws IOException {
        data = new byte[rdi.getInt()];
        rdi.get(data);
    }

    @Override
    public KeyType type() {
        return KeyType.UTF8_STRING;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(data);
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof UTF8StringKey) {
            return Arrays.equals(((UTF8StringKey) o).data, data);
        } else {
            return false;
        }
    }

    @Override
    public void writeData(final ReusableDataOutputStream stream)
        throws IOException
    {
        stream.writeInt(data.length);
        stream.write(data);
    }

    @Override
    public int weight() {
        return OVERHEAD + data.length;
    }

    @Override
    public String toString() {
        return new String(data, StandardCharsets.UTF_8);
    }
}
