package ru.yandex.jzabkv.node;

import java.io.IOException;

import ru.yandex.jzabkv.key.Key;
import ru.yandex.jzabkv.ReusableDataInput;
import ru.yandex.jzabkv.ReusableDataOutputStream;

public abstract class AbstractNode implements Node {
    private static final NodeType[] TYPES = NodeType.values();
    private Node next = null;
    private Key key;
    private final long evictionTimestamp;

    protected AbstractNode(final Key key, final long evictionTimestamp) {
        this.key = key;
        this.evictionTimestamp = evictionTimestamp;
    }

    protected AbstractNode(final Key key, final ReusableDataInput rdi)
        throws IOException
    {
        this.key = key;
        this.evictionTimestamp = rdi.getLong();
    }

/*
    public String getString(final ByteBuffer bb) throws IOException {
        try {
            int length = bb.getInt();
            final byte[] bytes = new byte[length];
            bb.get(bytes);
            return StringDecoder.UTF_8.get().process(bytes, 0, length);
        } catch (Exception e) {
            throw new IOException(e);
        }
    }
*/
    public abstract void writeData(final ReusableDataOutputStream stream)
        throws IOException;

    @Override
    public void write(final ReusableDataOutputStream stream)
        throws IOException
    {
        stream.writeInt(type().ordinal());
        stream.writeLong(evictionTimestamp);
        writeData(stream);
    }

    public static NodeType getNodeType(final ReusableDataInput rdi)
        throws IOException
    {
        return TYPES[rdi.getInt()];
    }

    @Override
    public Node next() {
        return next;
    }

    public void next(final Node next) {
        this.next = next;
    }

    @Override
    public Key key() {
        return key;
    }

    @Override
    public long evictionTimestamp() {
        return evictionTimestamp;
    }
}
