package ru.yandex.jzabkv.node;

import java.io.IOException;

import ru.yandex.jzabkv.key.Key;
import ru.yandex.jzabkv.ReusableDataInput;

public enum NodeType {
    STRING {
        @Override
        public Node create(
            final Key key,
            final ReusableDataInput rdi)
            throws IOException
        {
            return new StringNode(key, rdi);
        }
    };

    public abstract Node create(
        final Key key,
        final ReusableDataInput rdi)
        throws IOException;
}
