package ru.yandex.jzabkv.storage;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;

import ru.yandex.jzabkv.key.Key;
import ru.yandex.jzabkv.node.Node;

public interface Storage extends Closeable {
    int size();

    long weight();

    long maxWeight();

    void clear();

    Node get(final Key key);

    void put(final Node node);

    Collection<Key> tryPut(final Node node);

    void delete(final Key node);

    void restore(final FileInputStream is) throws IOException;

    void save(final FileOutputStream os) throws IOException;

    void dump(final Logger logger);
}
