package ru.yandex.search.so;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractKnnConfigBuilder
    <T extends AbstractKnnConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements KnnConfig
{
    private File snapshotPath;
    private int hnswM;
    private int hnswEf;
    private int hnswEfConstruction;
    private int defaultSearchK;
    private int searchThreads;
    private int searchQueueSize;

    protected AbstractKnnConfigBuilder(
        final KnnConfig config)
    {
        super(config);
        snapshotPath = config.snapshotPath();
        hnswM = config.hnswM();
        hnswEf = config.hnswEf();
        hnswEfConstruction = config.hnswEfConstruction();
        defaultSearchK = config.defaultSearchK();
        searchThreads = config.searchThreads();
        searchQueueSize = config.searchQueueSize();
    }

    protected AbstractKnnConfigBuilder(
        final IniConfig config,
        final KnnConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        snapshotPath = config.getOutputFile(
            "snapshot-path",
            defaults.snapshotPath());
        hnswM = config.getInt(
            "hnsw-m",
            defaults.hnswM());
        hnswEf = config.getInt(
            "hnsw-ef",
            defaults.hnswEf());
        hnswEfConstruction = config.getInt(
            "hnsw-ef-construction",
            defaults.hnswEfConstruction());
        defaultSearchK = config.getInt(
            "default-search-h",
            defaults.defaultSearchK());
        searchThreads = config.getInt(
            "search-threads",
            defaults.searchThreads());
        searchQueueSize = config.getInt(
            "search-queue-size",
            defaults.searchQueueSize());
    }

    @Override
    public File snapshotPath() {
        return snapshotPath;
    }

    public T snapshotPath(final File snapshotPath) {
        this.snapshotPath = snapshotPath;
        return self();
    }

    @Override
    public int hnswM() {
        return hnswM;
    }

    public T hnswM(final int hnswM) {
        this.hnswM = hnswM;
        return self();
    }

    @Override
    public int hnswEf() {
        return hnswEf;
    }

    public T hnswEf(final int hnswEf) {
        this.hnswEf = hnswEf;
        return self();
    }

    @Override
    public int hnswEfConstruction() {
        return hnswEfConstruction;
    }

    public T hnswEfConstuction(final int hnswEfConstruction) {
        this.hnswEfConstruction = hnswEfConstruction;
        return self();
    }

    @Override
    public int defaultSearchK() {
        return defaultSearchK;
    }

    public T defaultSearchK(final int defaultSearchK) {
        this.defaultSearchK = defaultSearchK;
        return self();
    }

    @Override
    public int searchThreads() {
        return searchThreads;
    }

    public T searchThreads(final int searchThreads) {
        this.searchThreads = searchThreads;
        return self();
    }

    @Override
    public int searchQueueSize() {
        return searchQueueSize;
    }

    public T searchQueueSize(final int searchQueueSize) {
        this.searchQueueSize = searchQueueSize;
        return self();
    }

    public void copyTo(final AbstractKnnConfigBuilder<?> other) {
        copyTo((AbstractUniversalSearchProxyConfigBuilder<?>) other);
    }
}
