package ru.yandex.search.so;

import java.io.IOException;
import java.util.logging.Logger;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncResponseProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.logger.PrefixedLogger;

public class AddPointHandler implements HttpAsyncRequestHandler<JsonObject>
{
    private final Knn knn;

    public AddPointHandler(final Knn knn) {
        this.knn = knn;
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
            final HttpRequest request,
            final HttpContext context)
        throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncTypesafeDomConsumer(
            ((HttpEntityEnclosingRequest) request).getEntity(),
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

/*
{
    "ns":["hot_spam"],
    "point":{
        "coordinate":$COORDS,
        "value":{
            "spam":true,
            "stid":"$STID",
            "uid":"$PUID",
            "smtp_id":"$QUEUE_ID"
        }
    }
}
*/
    @Override
    public void handle(
        final JsonObject payload,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
//        ProxySession session = new BasicProxySession(proxy, exchange, context);
        try {
            JsonMap request = payload.asMap();
            JsonMap point = request.getMap("point");
            MinHashMessage msg = new MinHashMessage(point);
            boolean sync = request.getBoolean("sync", false);
            PrefixedLogger logger =
                (PrefixedLogger) context.getAttribute(HttpProxy.LOGGER);
            if (sync) {
                knn.addPoint(
                    msg,
                    new SyncCallback(knn, exchange, context, logger));
            } else {
                knn.addPoint(msg, null);
                logger.severe("Added point, index size: " + knn.indexSize());
                BasicAsyncResponseProducerGenerator respGenerator =
                    new BasicAsyncResponseProducerGenerator(
                        HttpStatus.SC_OK,
                        "Ok");
                exchange.submitResponse(respGenerator.get());
            }
        } catch (JsonException|IOException e) {
            throw new BadRequestException(e);
        }
    }

    private static class SyncCallback implements FutureCallback<Integer> {
        private final Knn knn;
        private final HttpAsyncExchange exchange;
        private final HttpContext context;
        private final Logger logger;

        SyncCallback(
            final Knn knn,
            final HttpAsyncExchange exchange,
            final HttpContext context,
            final Logger logger)
        {
            this.knn = knn;
            this.exchange = exchange;
            this.context = context;
            this.logger = logger;
        }

        @Override
        public void completed(final Integer result) {
            logger.severe("Added point, index size: " + result);
            BasicAsyncResponseProducerGenerator respGenerator =
                new BasicAsyncResponseProducerGenerator(
                        HttpStatus.SC_OK,
                        "Ok");
            exchange.submitResponse(respGenerator.get());
        }

        @Override
        public void cancelled() {
        }

        @Override
        public void failed(final Exception e) {
            exchange.submitResponse(knn.handleException(e, context));
        }
    }
}

