package ru.yandex.search.so;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.ServiceUnavailableException;

public class FlushHandler implements ProxyRequestHandler {
    private final Knn knn;

    public FlushHandler(final Knn knn) {
        this.knn = knn;
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        try {
            knn.flush();
        } catch (IOException e) {
            throw new ServiceUnavailableException(e);
        }
        session.response(HttpStatus.SC_OK);
    }
}

