package ru.yandex.search.so;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

import org.apache.http.protocol.HttpContext;

import ru.yandex.function.BasicGenericConsumer;
import ru.yandex.http.util.nio.AbstractAsyncByteArrayConsumer;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.JsonParser;
import ru.yandex.json.parser.StackContentHandler;

public class GzipEntityAsyncConsumer
    extends AbstractAsyncByteArrayConsumer<JsonObject>
{
    @Override
    protected JsonObject buildResult(final HttpContext context)
        throws IOException
    {
        try (Reader reader =
            new InputStreamReader(
                new GZIPInputStream(
                    new ByteArrayInputStream(buf, 0, len)),
                StandardCharsets.UTF_8))
        {
            JsonParser parser;
            BasicGenericConsumer<JsonObject, JsonException> consumer;
            consumer = new BasicGenericConsumer<>();
            parser =
                new JsonParser(new StackContentHandler(
                    new TypesafeValueContentHandler(consumer)));
            parser.parse(reader);
            return consumer.get();
        } catch (JsonException e) {
            throw new IOException("Json parse error", e);
        }
    }
}

