package ru.yandex.search.so;

import java.io.File;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableKnnConfig
    extends ImmutableUniversalSearchProxyConfig
    implements KnnConfig
{
    private final File snapshotPath;
    private final int hnswM;
    private final int hnswEf;
    private final int hnswEfConstruction;
    private final int defaultSearchK;
    private final int searchThreads;
    private final int searchQueueSize;

    public ImmutableKnnConfig(
        final KnnConfig config)
        throws ConfigException
    {
        super(config);
        this.snapshotPath = config.snapshotPath();
        this.hnswM = config.hnswM();
        this.hnswEf = config.hnswEf();
        this.hnswEfConstruction = config.hnswEfConstruction();
        this.defaultSearchK = config.defaultSearchK();
        this.searchThreads = config.searchThreads();
        this.searchQueueSize = config.searchQueueSize();
    }

    @Override
    public File snapshotPath() {
        return snapshotPath;
    }

    @Override
    public int hnswM() {
        return hnswM;
    }

    @Override
    public int hnswEf() {
        return hnswEf;
    }

    @Override
    public int hnswEfConstruction() {
        return hnswEfConstruction;
    }

    @Override
    public int defaultSearchK() {
        return defaultSearchK;
    }

    @Override
    public int searchThreads() {
        return searchThreads;
    }

    @Override
    public int searchQueueSize() {
        return searchQueueSize;
    }
}
