package ru.yandex.search.so;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class KnnConfigBuilder
    extends AbstractKnnConfigBuilder<
        KnnConfigBuilder>
{
    public KnnConfigBuilder()
    {
        super(KnnConfigDefaults.INSTANCE);
    }

    public KnnConfigBuilder(
        final KnnConfig config)
    {
        super(config);
    }

    public KnnConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, KnnConfigDefaults.INSTANCE);
    }

    public KnnConfigBuilder(
        final IniConfig config,
        final KnnConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public KnnConfigBuilder self() {
        return this;
    }

    public ImmutableKnnConfig build()
        throws ConfigException
    {
        return new ImmutableKnnConfig(this);
    }
}
