package ru.yandex.search.so;

import java.io.File;

import ru.yandex.search.proxy.universal.UniversalSearchProxyConfigDefaults;

public class KnnConfigDefaults
    extends UniversalSearchProxyConfigDefaults
    implements KnnConfig
{
    public static final KnnConfigDefaults INSTANCE =
        new KnnConfigDefaults();
    private static final File DEFAULT_SNAPSHOT_PATH = new File("snapshot.dmp");
    private static final int DEFAULT_M = 32;
    private static final int DEFAULT_EF = 100;
    private static final int DEFAULT_EF_CONSTRUCTION = 100;
    private static final int DEFAULT_SEARCH_K = 5;
    private static final int DEFAULT_SEARCH_QUEUE_SIZE = 1000;
    private static final int DEFAULT_SEARCH_THREADS = 8;

    protected KnnConfigDefaults() {
    }

    @Override
    public File snapshotPath() {
        return DEFAULT_SNAPSHOT_PATH;
    }

    @Override
    public int hnswM() {
        return DEFAULT_M;
    }

    @Override
    public int hnswEf() {
        return DEFAULT_EF;
    }

    @Override
    public int hnswEfConstruction() {
        return DEFAULT_EF_CONSTRUCTION;
    }

    @Override
    public int defaultSearchK() {
        return DEFAULT_SEARCH_K;
    }

    @Override
    public int searchThreads() {
        return DEFAULT_SEARCH_THREADS;
    }

    @Override
    public int searchQueueSize() {
        return DEFAULT_SEARCH_QUEUE_SIZE;
    }
}
