package ru.yandex.search.so;

import com.github.jelmerk.knn.DistanceFunction;

public enum MinHashDistance implements DistanceFunction<int[], Float> {
    INSTANCE;

    @Override
    public Float distance(final int[] v1, final int[] v2) {
        int len = Math.min(v1.length, v2.length);
        int dist = len;
        for (int i = 0; i < len; i++) {
//            if ((v1[i] ^ v2[i]) == 0) {
//                dist--;
//            }
            if (v1[i] == v2[i]) {
                dist--;
            }
        }
        return Float.valueOf((float) dist / (float) len);
    }
}

