package ru.yandex.search.passport.korobochka;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.URIConfig;
import ru.yandex.http.config.URIConfigBuilder;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractKorobochkaConfigBuilder
    <T extends AbstractKorobochkaConfigBuilder<T>>
    extends AbstractHttpProxyConfigBuilder<T>
    implements KorobochkaConfig
{
    private int parseThreads;
    private int parseQueue;
    private URIConfigBuilder korobochkaPassport;
    private URIConfigBuilder korobochkaAvtoRu;
    private HttpHostConfigBuilder blackboxConfig;
    private String korobochkaPassportLogin;
    private String korobochkaPassportPassword;
    private String korobochkaAvtoRuLogin;
    private String korobochkaAvtoRuPassword;

    protected AbstractKorobochkaConfigBuilder(
        final KorobochkaConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        korobochkaPassport =
            new URIConfigBuilder(config.korobochkaPassport());
        korobochkaAvtoRu =
            new URIConfigBuilder(config.korobochkaAvtoRu());
        korobochkaPassportLogin = config.korobochkaPassportLogin();
        korobochkaPassportPassword = config.korobochkaPassportPassword();
        korobochkaAvtoRuLogin = config.korobochkaAvtoRuLogin();
        korobochkaAvtoRuPassword = config.korobochkaAvtoRuPassword();
        blackboxConfig(config.blackboxConfig());
    }

    protected AbstractKorobochkaConfigBuilder(
        final IniConfig config,
        final KorobochkaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        parseThreads = config.getInt("parse-threads", defaults.parseThreads());
        parseQueue = config.getInt("parse-queue", defaults.parseQueue());
        IniConfig korobochkaPassportConfig =
            config.section("korobochka-passport");
        IniConfig korobochkaAvtoRuConfig = config.section("korobochka-avtoru");
        korobochkaPassport =
            new URIConfigBuilder(
                korobochkaPassportConfig,
                defaults.korobochkaPassport());
        korobochkaAvtoRu =
            new URIConfigBuilder(
                korobochkaAvtoRuConfig,
                defaults.korobochkaAvtoRu());
        korobochkaPassportLogin = korobochkaPassportConfig.getString(
            "login",
            defaults.korobochkaPassportLogin());
        korobochkaPassportPassword = korobochkaPassportConfig.getString(
            "password",
            defaults.korobochkaPassportPassword());
        korobochkaAvtoRuLogin = korobochkaAvtoRuConfig.getString(
            "login",
            defaults.korobochkaAvtoRuLogin());
        korobochkaAvtoRuPassword = korobochkaAvtoRuConfig.getString(
            "password",
            defaults.korobochkaAvtoRuPassword());
        IniConfig blackboxSection = config.section("blackbox");
        blackboxConfig = new HttpHostConfigBuilder(
            blackboxSection,
            defaults.blackboxConfig());
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public URIConfigBuilder korobochkaPassport() {
        return korobochkaPassport;
    }

    public T korobochkaPassport(final URIConfig korobochkaPassport) {
        this.korobochkaPassport
            = new URIConfigBuilder(korobochkaPassport);
        return self();
    }

    @Override
    public URIConfigBuilder korobochkaAvtoRu() {
        return korobochkaAvtoRu;
    }

    public T korobochkaAvtoRu(final URIConfig korobochkaAvtoRu) {
        this.korobochkaAvtoRu = new URIConfigBuilder(korobochkaAvtoRu);
        return self();
    }

    @Override
    public String korobochkaPassportLogin() {
        return korobochkaPassportLogin;
    }

    public T korobochkaPassportLogin(final String korobochkaPassportLogin) {
        this.korobochkaPassportLogin = korobochkaPassportLogin;
        return self();
    }

    @Override
    public String korobochkaPassportPassword() {
        return korobochkaPassportPassword;
    }

    public T korobochkaPassportPassword(final String korobochkaPassportPassword) {
        this.korobochkaPassportPassword = korobochkaPassportPassword;
        return self();
    }

    @Override
    public String korobochkaAvtoRuLogin() {
        return korobochkaAvtoRuLogin;
    }

    public T korobochkaAvtoRuLogin(final String korobochkaAvtoRuLogin) {
        this.korobochkaAvtoRuLogin = korobochkaAvtoRuLogin;
        return self();
    }

    @Override
    public String korobochkaAvtoRuPassword() {
        return korobochkaAvtoRuPassword;
    }

    public T korobochkaAvtoRuPassword(final String korobochkaAvtoRuPassword) {
        this.korobochkaAvtoRuPassword = korobochkaAvtoRuPassword;
        return self();
    }

    @Override
    public HttpHostConfigBuilder blackboxConfig() {
        return blackboxConfig;
    }

    public T blackboxConfig(final HttpHostConfig blackboxConfig) {
        this.blackboxConfig = new HttpHostConfigBuilder(blackboxConfig);
        return self();
    }

    public void copyTo(final AbstractKorobochkaConfigBuilder<?> other) {
        copyTo((AbstractHttpProxyConfigBuilder<?>) other);
    }
}
