package ru.yandex.search.passport.korobochka;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.config.ImmutableURIConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableKorobochkaConfig
    extends ImmutableHttpProxyConfig
    implements KorobochkaConfig
{
    private final int parseThreads;
    private final int parseQueue;
    private final ImmutableURIConfig korobochkaPassport;
    private final ImmutableURIConfig korobochkaAvtoRu;
    private final String korobochkaPassportLogin;
    private final String korobochkaPassportPassword;
    private final String korobochkaAvtoRuLogin;
    private final String korobochkaAvtoRuPassword;
    private final ImmutableHttpHostConfig blackboxConfig;

    public ImmutableKorobochkaConfig(
        final KorobochkaConfig config)
        throws ConfigException
    {
        super(config);

        parseThreads = config.parseThreads();
        parseQueue = config.parseQueue();
        korobochkaPassport =
            new ImmutableURIConfig(config.korobochkaPassport());
        korobochkaAvtoRu =
            new ImmutableURIConfig(config.korobochkaAvtoRu());
        korobochkaPassportLogin = config.korobochkaPassportLogin();
        korobochkaPassportPassword = config.korobochkaPassportPassword();
        korobochkaAvtoRuLogin = config.korobochkaAvtoRuLogin();
        korobochkaAvtoRuPassword = config.korobochkaAvtoRuPassword();
        blackboxConfig = new ImmutableHttpHostConfig(config.blackboxConfig());
    }

    @Override
    public int parseThreads() {
        return parseThreads;
    }

    @Override
    public int parseQueue() {
        return parseQueue;
    }

    @Override
    public ImmutableURIConfig korobochkaPassport() {
        return korobochkaPassport;
    }

    @Override
    public ImmutableURIConfig korobochkaAvtoRu() {
        return korobochkaAvtoRu;
    }

    @Override
    public String korobochkaPassportLogin() {
        return korobochkaPassportLogin;
    }

    @Override
    public String korobochkaPassportPassword() {
        return korobochkaPassportPassword;
    }

    @Override
    public String korobochkaAvtoRuLogin() {
        return korobochkaAvtoRuLogin;
    }

    @Override
    public String korobochkaAvtoRuPassword() {
        return korobochkaAvtoRuPassword;
    }

    @Override
    public ImmutableHttpHostConfig blackboxConfig() {
        return blackboxConfig;
    }
}
