package ru.yandex.search.passport.korobochka;

import java.io.IOException;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.collection.Pattern;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.parser.config.ConfigException;

public class Korobochka extends HttpProxy<ImmutableKorobochkaConfig> {
    private final KorobochkaSender passportSender;
    private final KorobochkaSender avtoRuSender;
    private final BlackboxClient blackboxClient;

    public Korobochka(final ImmutableKorobochkaConfig config)
        throws ConfigException, IOException
    {
        super(config);

        passportSender =
            new KorobochkaSender(
                this,
                config.korobochkaPassport(),
                config.korobochkaPassportLogin(),
                config.korobochkaPassportPassword(),
                "passport");
        avtoRuSender =
            new KorobochkaSender(
                this,
                config.korobochkaAvtoRu(),
                config.korobochkaAvtoRuLogin(),
                config.korobochkaAvtoRuPassword(),
                "avtoru");

        blackboxClient =
            registerClient(
                "Blackbox",
                new BlackboxClient(reactor, config.blackboxConfig()),
                config.blackboxConfig());

        register(
            new Pattern<>("/logbroke-it", true),
            new LogbrokeItHandler(this),
            RequestHandlerMapper.POST);

        register(
            new Pattern<>("/tables", true),
            new FakeTablesHandler());
    }

    @Override
    public void close() throws IOException {
        super.close();
        passportSender.close();
        avtoRuSender.close();
        blackboxClient.close();
    }

    public KorobochkaSender passportSender() {
        return passportSender;
    }

    public KorobochkaSender avtoRuSender() {
        return avtoRuSender;
    }

    public BlackboxClient blackboxClient() {
        return blackboxClient;
    }
}
